jQuery(document).ready(function($) {
    var verifiedWhatsapp = '';
    var verifiedToken = '';

    // Get nonces from data attributes
    var $form = $('.hk-proposal-form');
    var ajaxurl = $form.data('ajaxurl');
    var otpNonce = $form.data('otp-nonce');
    var proposalNonce = $form.data('proposal-nonce');

    // Fallback to hkAjax if available
    if (typeof hkAjax !== 'undefined') {
        ajaxurl = ajaxurl || hkAjax.ajaxurl;
        otpNonce = otpNonce || hkAjax.otp_nonce;
        proposalNonce = proposalNonce || hkAjax.proposal_nonce;
    }

    // Modal close button
    $('.hk-modal-close').on('click', function() {
        $('#hk-otp-modal').hide();
    });

    // Close modal when clicking outside
    $(window).on('click', function(e) {
        if ($(e.target).is('#hk-otp-modal')) {
            $('#hk-otp-modal').hide();
        }
    });

    // Send OTP
    $('#hk-send-otp').on('click', function() {
        var whatsapp = $('#hk-whatsapp').val().trim();
        if (!whatsapp) {
            alert('Masukkan nomor WhatsApp');
            return;
        }

        var btn = $(this);
        btn.prop('disabled', true).text('Mengirim...');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'hk_send_otp',
                nonce: otpNonce,
                whatsapp: whatsapp
            },
            success: function(response) {
                btn.prop('disabled', false).text('Kirim OTP');
                if (response.success) {
                    $('#hk-otp-modal').show();
                    $('#hk-otp-code').focus();
                } else {
                    alert(response.data.message || 'Gagal mengirim OTP');
                }
            },
            error: function() {
                alert('Terjadi kesalahan');
                btn.prop('disabled', false).text('Kirim OTP');
            }
        });
    });

    // Verify OTP
    $('#hk-verify-otp').on('click', function() {
        var whatsapp = $('#hk-whatsapp').val().trim();
        var otp = $('#hk-otp-code').val().trim();

        if (!otp) {
            alert('Masukkan kode OTP');
            return;
        }

        var btn = $(this);
        btn.prop('disabled', true).text('Memverifikasi...');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'hk_verify_otp',
                nonce: otpNonce,
                whatsapp: whatsapp,
                otp: otp
            },
            success: function(response) {
                if (response.success) {
                    verifiedWhatsapp = whatsapp;
                    verifiedToken = response.data.token;
                    $('#hk-verified-token').val(verifiedToken);
                    $('#hk-verified-whatsapp').val(verifiedWhatsapp);
                    $('#hk-otp-modal').hide();
                    $('#hk-otp-section').hide();
                    $('#hk-proposal-form-main').show();
                } else {
                    alert(response.data.message || 'OTP tidak valid');
                    btn.prop('disabled', false).text('Verifikasi OTP');
                }
            },
            error: function() {
                alert('Terjadi kesalahan');
                btn.prop('disabled', false).text('Verifikasi OTP');
            }
        });
    });

    // Submit Proposal
    $('#hk-proposal-form-main').on('submit', function(e) {
        e.preventDefault();

        if (!proposalNonce) {
            alert('Error: Nonce tidak ditemukan. Silakan refresh halaman.');
            return;
        }

        var formData = new FormData(this);
        formData.set('action', 'hk_submit_proposal');
        formData.set('nonce', proposalNonce);
        formData.set('whatsapp', verifiedWhatsapp);
        formData.set('token', verifiedToken);

        var btn = $(this).find('button[type="submit"]');
        btn.prop('disabled', true).text('Mengirim...');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    $('#hk-proposal-form-main').hide();
                    $('#hk-success-message').show();
                } else {
                    alert(response.data.message || 'Gagal mengirim proposal');
                    btn.prop('disabled', false).text('Submit Proposal');
                }
            },
            error: function() {
                alert('Terjadi kesalahan');
                btn.prop('disabled', false).text('Submit Proposal');
            }
        });
    });
});
