<?php
/**
 * Plugin Name: Hallo Ketua
 * Description: Plugin untuk submit proposal, janji temu, dan profile ketua dengan integrasi WhatsApp
 * Version: 1.0.0
 * Author: Your Name
 */

if (!defined('ABSPATH')) exit;

define('HK_VERSION', '1.0.0');
define('HK_PATH', plugin_dir_path(__FILE__));
define('HK_URL', plugin_dir_url(__FILE__));
define('HK_API_KEY', defined('HK_STARSENDER_API_KEY') ? HK_STARSENDER_API_KEY : '3a52c247-446d-4388-850b-c5b21f8aca9e');

// Autoload classes
spl_autoload_register(function ($class) {
    $prefix = 'HK_';
    $base_dir = HK_PATH . 'includes/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;

    $relative_class = substr($class, $len);
    $file = $base_dir . 'class-' . strtolower(str_replace('_', '-', $relative_class)) . '.php';

    if (file_exists($file)) require $file;
});

// Activation hook
register_activation_hook(__FILE__, function() {
    require_once HK_PATH . 'includes/class-database.php';
    HK_Database::create_tables();
    flush_rewrite_rules();
});

// Deactivation hook
register_deactivation_hook(__FILE__, function() {
    flush_rewrite_rules();
});

// Initialize plugin
add_action('plugins_loaded', function() {
    // Set timezone to Jakarta
    date_default_timezone_set('Asia/Jakarta');

    // Load classes
    require_once HK_PATH . 'includes/class-database.php';
    require_once HK_PATH . 'includes/class-starsender.php';
    require_once HK_PATH . 'includes/class-webhook.php';
    require_once HK_PATH . 'includes/class-setting.php';
    require_once HK_PATH . 'includes/class-proposal.php';
    require_once HK_PATH . 'includes/class-appointment.php';
    require_once HK_PATH . 'includes/class-admin.php';
    require_once HK_PATH . 'includes/class-public.php';

    // Initialize
    new HK_Setting();
    new HK_Webhook();
    new HK_Proposal();
    new HK_Appointment();
    new HK_Admin();
    new HK_Public();
});
