<?php
if (!defined('ABSPATH')) exit;

class HK_Admin {

    public function __construct() {
        add_action('admin_menu', [$this, 'add_menu']);
    }

    public function add_menu() {
        add_submenu_page(
            'hallo-ketua-settings',
            'Proposals',
            'Proposals',
            'manage_options',
            'hk-proposals',
            [$this, 'proposals_page']
        );

        add_submenu_page(
            'hallo-ketua-settings',
            'Appointments',
            'Appointments',
            'manage_options',
            'hk-appointments',
            [$this, 'appointments_page']
        );
    }

    public function proposals_page() {
        global $wpdb;
        $proposals = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}hk_proposals ORDER BY created_at DESC");

        ?>
        <div class="wrap">
            <h1>Proposals</h1>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Lembaga</th>
                        <th>PJ</th>
                        <th>Event</th>
                        <th>Jumlah</th>
                        <th>Status</th>
                        <th>WhatsApp</th>
                        <th>Created</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($proposals as $p): ?>
                    <tr>
                        <td><?php echo $p->id; ?></td>
                        <td><?php echo esc_html($p->lembaga); ?></td>
                        <td><?php echo esc_html($p->penanggung_jawab); ?></td>
                        <td><?php echo esc_html(wp_trim_words($p->event_detail, 10)); ?></td>
                        <td><?php echo esc_html($p->jumlah); ?></td>
                        <td>
                            <span class="status-badge status-<?php echo $p->status; ?>">
                                <?php echo ucfirst($p->status); ?>
                            </span>
                        </td>
                        <td><?php echo esc_html($p->whatsapp); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($p->created_at)); ?></td>
                        <td>
                            <a href="#" onclick="showProposalDetail(<?php echo $p->id; ?>); return false;">View</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <style>
        .status-badge {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
        }
        .status-pending { background: #ffa500; color: white; }
        .status-approved { background: #28a745; color: white; }
        .status-rejected { background: #dc3545; color: white; }
        .status-waiting_reason { background: #17a2b8; color: white; }
        </style>

        <script>
        function showProposalDetail(id) {
            alert('Detail proposal ID: ' + id + '\nImplement modal detail di sini');
        }
        </script>
        <?php
    }

    public function appointments_page() {
        global $wpdb;
        $appointments = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}hk_appointments ORDER BY created_at DESC");

        ?>
        <div class="wrap">
            <h1>Appointments</h1>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama</th>
                        <th>Keperluan</th>
                        <th>Tanggal & Jam</th>
                        <th>Status</th>
                        <th>WhatsApp</th>
                        <th>Created</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($appointments as $a): ?>
                    <tr>
                        <td><?php echo $a->id; ?></td>
                        <td><?php echo esc_html($a->nama); ?></td>
                        <td><?php echo esc_html(wp_trim_words($a->keperluan, 10)); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($a->tanggal_jam)); ?></td>
                        <td>
                            <span class="status-badge status-<?php echo $a->status; ?>">
                                <?php echo ucfirst($a->status); ?>
                            </span>
                        </td>
                        <td><?php echo esc_html($a->whatsapp); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($a->created_at)); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <style>
        .status-badge {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
        }
        .status-pending { background: #ffa500; color: white; }
        .status-approved { background: #28a745; color: white; }
        .status-rejected { background: #dc3545; color: white; }
        .status-waiting_reason { background: #17a2b8; color: white; }
        </style>
        <?php
    }
}
