<?php
if (!defined('ABSPATH')) exit;

class HK_Database {

    public static function create_tables() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        // Proposals table
        $sql_proposals = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}hk_proposals (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            whatsapp varchar(20) NOT NULL,
            lembaga varchar(255) NOT NULL,
            penanggung_jawab varchar(255) NOT NULL,
            alamat text NOT NULL,
            event_detail text NOT NULL,
            alasan_bantuan text NOT NULL,
            feedback text NOT NULL,
            jumlah varchar(100) NOT NULL,
            kapan varchar(100) NOT NULL,
            dimana varchar(255) NOT NULL,
            file_url varchar(500),
            status varchar(20) DEFAULT 'pending',
            alasan_keputusan text,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id)
        ) $charset_collate;";

        // Appointments table
        $sql_appointments = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}hk_appointments (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            whatsapp varchar(20) NOT NULL,
            nama varchar(255) NOT NULL,
            keperluan text NOT NULL,
            tanggal_jam datetime NOT NULL,
            status varchar(20) DEFAULT 'pending',
            alasan_keputusan text,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id)
        ) $charset_collate;";

        // OTP table
        $sql_otp = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}hk_otp (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            whatsapp varchar(20) NOT NULL,
            otp varchar(6) NOT NULL,
            verified tinyint(1) DEFAULT 0,
            expires_at datetime NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY whatsapp (whatsapp)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql_proposals);
        dbDelta($sql_appointments);
        dbDelta($sql_otp);
    }
}
