<?php
if (!defined('ABSPATH')) exit;

class HK_Proposal {

    public function __construct() {
        add_action('wp_ajax_hk_send_otp', [$this, 'send_otp']);
        add_action('wp_ajax_nopriv_hk_send_otp', [$this, 'send_otp']);
        add_action('wp_ajax_hk_verify_otp', [$this, 'verify_otp']);
        add_action('wp_ajax_nopriv_hk_verify_otp', [$this, 'verify_otp']);
        add_action('wp_ajax_hk_submit_proposal', [$this, 'submit_proposal']);
        add_action('wp_ajax_nopriv_hk_submit_proposal', [$this, 'submit_proposal']);
    }

    public function send_otp() {
        check_ajax_referer('hk_otp_nonce', 'nonce');

        $whatsapp = sanitize_text_field($_POST['whatsapp'] ?? '');
        if (empty($whatsapp)) {
            wp_send_json_error(['message' => 'WhatsApp number required']);
        }

        $result = HK_StarSender::send_otp($whatsapp);
        if ($result['success']) {
            wp_send_json_success(['message' => 'OTP sent']);
        } else {
            wp_send_json_error(['message' => 'Failed to send OTP']);
        }
    }

    public function verify_otp() {
        check_ajax_referer('hk_otp_nonce', 'nonce');

        $whatsapp = sanitize_text_field($_POST['whatsapp'] ?? '');
        $otp = sanitize_text_field($_POST['otp'] ?? '');

        if (HK_StarSender::verify_otp($whatsapp, $otp)) {
            wp_send_json_success(['message' => 'OTP verified', 'token' => wp_create_nonce('hk_verified_' . $whatsapp)]);
        } else {
            wp_send_json_error(['message' => 'Invalid or expired OTP']);
        }
    }

    public function submit_proposal() {
        check_ajax_referer('hk_proposal_nonce', 'nonce');

        $whatsapp = sanitize_text_field($_POST['whatsapp'] ?? '');
        $token = sanitize_text_field($_POST['token'] ?? '');

        if (!wp_verify_nonce($token, 'hk_verified_' . $whatsapp)) {
            wp_send_json_error(['message' => 'Invalid verification']);
        }

        // Handle file upload
        $file_url = '';
        if (!empty($_FILES['file']['name'])) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');

            $file = $_FILES['file'];
            $max_size = 10 * 1024 * 1024; // 10MB

            if ($file['size'] > $max_size) {
                wp_send_json_error(['message' => 'File size exceeds 10MB']);
            }

            $upload = wp_handle_upload($file, ['test_form' => false]);
            if (isset($upload['error'])) {
                wp_send_json_error(['message' => $upload['error']]);
            }

            $file_url = $upload['url'];
        }

        global $wpdb;
        $inserted = $wpdb->insert($wpdb->prefix . 'hk_proposals', [
            'whatsapp' => $whatsapp,
            'lembaga' => sanitize_text_field($_POST['lembaga'] ?? ''),
            'penanggung_jawab' => sanitize_text_field($_POST['penanggung_jawab'] ?? ''),
            'alamat' => sanitize_textarea_field($_POST['alamat'] ?? ''),
            'event_detail' => sanitize_textarea_field($_POST['event_detail'] ?? ''),
            'alasan_bantuan' => sanitize_textarea_field($_POST['alasan_bantuan'] ?? ''),
            'feedback' => sanitize_textarea_field($_POST['feedback'] ?? ''),
            'jumlah' => sanitize_text_field($_POST['jumlah'] ?? ''),
            'kapan' => sanitize_text_field($_POST['kapan'] ?? ''),
            'dimana' => sanitize_text_field($_POST['dimana'] ?? ''),
            'file_url' => $file_url,
            'status' => 'pending'
        ]);

        if ($inserted) {
            $proposal_id = $wpdb->insert_id;
            HK_StarSender::notify_ketua_proposal($proposal_id);
            wp_send_json_success(['message' => 'Proposal submitted successfully', 'id' => $proposal_id]);
        } else {
            wp_send_json_error(['message' => 'Failed to submit proposal']);
        }
    }
}
