<?php
if (!defined('ABSPATH')) exit;

class HK_Public {

    public function __construct() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);
        add_shortcode('hk_proposal_form', [$this, 'proposal_form_shortcode']);
        add_shortcode('hk_appointment_form', [$this, 'appointment_form_shortcode']);
        add_shortcode('hk_homepage', [$this, 'homepage_shortcode']);
    }

    public function enqueue_assets() {
        wp_enqueue_style('hk-proposal-css', HK_URL . 'assets/css/proposal.css', [], HK_VERSION);
        wp_enqueue_style('hk-appointment-css', HK_URL . 'assets/css/appointment.css', [], HK_VERSION);

        wp_enqueue_script('hk-proposal-js', HK_URL . 'assets/js/proposal.js', ['jquery'], HK_VERSION, true);
        wp_enqueue_script('hk-appointment-js', HK_URL . 'assets/js/appointment.js', ['jquery'], HK_VERSION, true);

        wp_localize_script('hk-proposal-js', 'hkAjax', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'otp_nonce' => wp_create_nonce('hk_otp_nonce'),
            'proposal_nonce' => wp_create_nonce('hk_proposal_nonce')
        ]);

        wp_localize_script('hk-appointment-js', 'hkAjax', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'otp_nonce' => wp_create_nonce('hk_otp_nonce'),
            'appointment_nonce' => wp_create_nonce('hk_appointment_nonce')
        ]);
    }

    public function proposal_form_shortcode() {
        ob_start();
        include HK_PATH . 'templates/form-proposal.php';
        return ob_get_clean();
    }

    public function appointment_form_shortcode() {
        ob_start();
        include HK_PATH . 'templates/form-appointment.php';
        return ob_get_clean();
    }

    public function homepage_shortcode() {
        ob_start();
        include HK_PATH . 'templates/homepage.php';
        return ob_get_clean();
    }
}
