<?php
if (!defined('ABSPATH')) exit;

$bio = get_option('hk_bio', '');
$slide_photos = get_option('hk_slide_photos', []);
$logos = get_option('hk_logos', []);
$pengalaman = get_option('hk_pengalaman', []);
$instagram_url = get_option('hk_instagram_url', '');
$tiktok_url = get_option('hk_tiktok_url', '');
?>

<div class="hk-homepage">

    <!-- Section 1: Slideshow -->
    <?php if (!empty($slide_photos)): ?>
    <section id="slide" class="hk-slide fade-in">
        <div class="hk-slider">
            <?php foreach (array_slice($slide_photos, 0, 15) as $photo): ?>
                <?php if ($photo): ?>
                <div class="hk-slide-item">
                    <img src="<?php echo esc_url($photo); ?>" alt="Slide">
                </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>

    <!-- Section 2: About Us + Partners -->
    <section id="tentang-partners" class="hk-dual-section fade-in">
        <div class="hk-dual-container">
            <!-- Kolom 1: About Us -->
            <div class="hk-about-box">
                <h2>Tentang Saya</h2>
                <p><?php echo nl2br(esc_html($bio)); ?></p>
            </div>

            <!-- Kolom 2: Partners -->
            <?php if (!empty($logos)): ?>
            <div class="hk-partners-box">
                <div class="hk-partners-slider-wrapper">
                    <button class="hk-partners-prev" aria-label="Previous">‹</button>
                    <div class="hk-partners-slider">
                        <?php foreach ($logos as $logo): ?>
                            <?php if ($logo): ?>
                            <div class="hk-logo-item">
                                <img src="<?php echo esc_url($logo); ?>" alt="Partner Logo">
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <button class="hk-partners-next" aria-label="Next">›</button>
                </div>
                <div class="hk-partners-dots"></div>
            </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Section 3: Experience -->
    <?php if (!empty($pengalaman)): ?>
    <section id="pengalaman" class="hk-experience-section fade-in">
        <div class="hk-container">
            <h2>Pengalaman Saya</h2>
            <div class="hk-timeline">
                <?php foreach ($pengalaman as $exp): ?>
                <div class="hk-timeline-item">
                    <div class="hk-timeline-year"><?php echo esc_html($exp['tahun']); ?></div>
                    <div class="hk-timeline-content">
                        <h3><?php echo esc_html($exp['judul']); ?></h3>
                        <h4><?php echo esc_html($exp['lembaga']); ?></h4>
                        <p><?php echo esc_html($exp['deskripsi']); ?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Section 4: Social Media -->
    <?php if ($instagram_url || $tiktok_url): ?>
    <section id="social" class="hk-social-section fade-in">
        <div class="hk-container">
            <h2>Temukan Saya di</h2>
            <div class="hk-social-links">
                <?php if ($instagram_url): ?>
                <a href="<?php echo esc_url($instagram_url); ?>" target="_blank" class="hk-social-link">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="2" y="2" width="20" height="20" rx="5" ry="5"/>
                        <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"/>
                        <line x1="17.5" y1="6.5" x2="17.51" y2="6.5"/>
                    </svg>
                    <span>Instagram</span>
                </a>
                <?php endif; ?>

                <?php if ($tiktok_url): ?>
                <a href="<?php echo esc_url($tiktok_url); ?>" target="_blank" class="hk-social-link">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z"/>
                    </svg>
                    <span>TikTok</span>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
</div>

<style>
/* Full Width Homepage */
.hk-homepage {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    margin: 0;
    padding: 0;
    width: 100%;
}

/* Section 1: Slideshow */
.hk-slide {
    position: relative;
    width: 100%;
    overflow: hidden;
    margin: 0;
    background: #000000;
}

.hk-slider {
    display: flex;
    width: 100%;
    transition: transform 0.5s ease;
}

.hk-slide-item {
    flex: 0 0 33.333%;
    padding: 0;
    box-sizing: border-box;
}

.hk-slide-item img {
    width: 100%;
    height: auto;
    aspect-ratio: 4 / 5;
    object-fit: cover;
    display: block;
}

/* Section 2: Dual Section (About + Partners) */
.hk-dual-section {
    width: 100%;
    margin: 0;
    padding: 0;
}

.hk-dual-container {
    display: flex;
    flex-direction: row;
    width: 100%;
    min-height: 400px;
}

.hk-about-box {
    flex: 1;
    background: var(--hk-primary, #05293c);
    color: #ffffff;
    padding: 4rem 3rem;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.hk-about-box h2 {
    font-size: 2rem;
    margin-bottom: 1.5rem;
    color: #ffffff;
}

.hk-about-box p {
    line-height: 1.8;
    font-size: 1.1rem;
}

.hk-partners-box {
    flex: 1;
    background: var(--hk-button, #eaee25);
    color: var(--hk-font, #05293c);
    padding: 4rem 3rem;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.hk-partners-box h2 {
    font-size: 2rem;
    margin-bottom: 1.5rem;
    color: var(--hk-font, #05293c);
}

/* Partners Slider */
.hk-partners-slider-wrapper {
    position: relative;
    overflow: hidden;
    padding: 0 50px;
}

.hk-partners-slider {
    display: flex;
    gap: 2rem;
    transition: transform 0.5s ease;
}

.hk-logo-item {
    flex: 0 0 calc(33.333% - 1.35rem);
    display: flex;
    align-items: center;
    justify-content: center;
}

.hk-logo-item img {
    width: 100%;
    height: 80px;
    object-fit: contain;
}

.hk-partners-prev,
.hk-partners-next {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(5, 41, 60, 0.5);
    color: #ffffff;
    border: none;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    font-size: 24px;
    cursor: pointer;
    z-index: 10;
    transition: background 0.3s ease;
}

.hk-partners-prev:hover,
.hk-partners-next:hover {
    background: rgba(5, 41, 60, 0.8);
}

.hk-partners-prev {
    left: 5px;
}

.hk-partners-next {
    right: 5px;
}

.hk-partners-dots {
    display: flex;
    justify-content: center;
    gap: 8px;
    margin-top: 1.5rem;
}

.hk-partner-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: rgba(5, 41, 60, 0.3);
    cursor: pointer;
    transition: background 0.3s ease;
}

.hk-partner-dot.active {
    background: rgba(5, 41, 60, 0.8);
}

/* Section 3: Experience */
.hk-experience-section {
    width: 100%;
    background: var(--hk-section-bg, #f8f6f0);
    color: var(--hk-font, #05293c);
    padding: 4rem 2rem;
}

.hk-container {
    max-width: 1200px;
    margin: 0 auto;
}

.hk-experience-section h2 {
    font-size: 2rem;
    margin-bottom: 2rem;
    text-align: center;
    color: var(--hk-font, #05293c);
}

.hk-timeline {
    margin-top: 2rem;
}

.hk-timeline-item {
    display: flex;
    gap: 2rem;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #ffffff;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.hk-timeline-year {
    font-weight: bold;
    font-size: 1.2rem;
    min-width: 100px;
    color: var(--hk-primary, #05293c);
}

.hk-timeline-content h3 {
    margin: 0 0 0.5rem;
    color: var(--hk-primary, #05293c);
}

.hk-timeline-content h4 {
    margin: 0 0 0.5rem;
    color: var(--hk-icon, #80a5b4);
}

.hk-timeline-content p {
    color: var(--hk-font, #05293c);
}

/* Section 4: Social Media */
.hk-social-section {
    width: 100%;
    background: var(--hk-section-bg, #f8f6f0);
    color: var(--hk-font, #05293c);
    padding: 4rem 2rem;
}

.hk-social-section h2 {
    font-size: 2rem;
    margin-bottom: 2rem;
    text-align: center;
    color: var(--hk-font, #05293c);
}

.hk-social-links {
    display: flex;
    justify-content: center;
    gap: 3rem;
    margin-top: 2rem;
}

.hk-social-link {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 1rem;
    color: var(--hk-primary, #05293c);
    text-decoration: none;
    padding: 2rem;
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.hk-social-link:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    color: var(--hk-icon, #80a5b4);
}

.hk-social-link svg {
    width: 48px;
    height: 48px;
}

.hk-social-link span {
    font-size: 1.1rem;
    font-weight: 600;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    /* Mobile: 1 photo per slide */
    .hk-slide-item {
        flex: 0 0 100%;
        padding: 0;
    }

    .hk-slider {
        padding: 0;
    }

    .hk-dual-container {
        flex-direction: column;
    }

    .hk-about-box,
    .hk-partners-box {
        padding: 3rem 2rem;
    }

    /* Mobile: 2 logos per slide */
    .hk-logo-item {
        flex: 0 0 calc(50% - 1rem);
    }

    .hk-partners-slider-wrapper {
        padding: 0 20px;
    }

    /* Hide arrows and dots on mobile */
    .hk-partners-prev,
    .hk-partners-next,
    .hk-partners-dots {
        display: none;
    }

    .hk-timeline-item {
        flex-direction: column;
        gap: 0.5rem;
    }

    .hk-social-links {
        flex-direction: column;
        gap: 1.5rem;
        align-items: center;
    }

    .hk-social-link {
        width: 200px;
    }
}

/* Fade-in Animation */
.fade-in {
    opacity: 0;
    animation: fadeIn 0.8s ease forwards;
}

.fade-in:nth-child(1) { animation-delay: 0.1s; }
.fade-in:nth-child(2) { animation-delay: 0.3s; }
.fade-in:nth-child(3) { animation-delay: 0.5s; }
.fade-in:nth-child(4) { animation-delay: 0.7s; }

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Slideshow auto-rotate (3 photos per view on desktop, 1 on mobile)
    var slider = document.querySelector('.hk-slider');
    if (slider && slider.children.length > 0) {
        var slideItems = slider.children.length;
        var currentSlide = 0;
        var slidesPerView = window.innerWidth <= 768 ? 1 : 3;
        var totalSlides = Math.ceil(slideItems / slidesPerView);

        function updateSlideshow() {
            var slideWidth = 100 / slidesPerView;
            var offset = currentSlide * slideWidth;
            slider.style.transform = 'translateX(-' + offset + '%)';
        }

        function nextSlide() {
            currentSlide = (currentSlide + 1) % totalSlides;
            updateSlideshow();
        }

        // Auto-rotate every 4 seconds
        var slideshowInterval = setInterval(nextSlide, 4000);

        // Re-calculate on resize
        window.addEventListener('resize', function() {
            var newSlidesPerView = window.innerWidth <= 768 ? 1 : 3;
            if (newSlidesPerView !== slidesPerView) {
                slidesPerView = newSlidesPerView;
                totalSlides = Math.ceil(slideItems / slidesPerView);
                currentSlide = 0;
                updateSlideshow();
            }
        });

        updateSlideshow();
    }

    // Partners Slider
    var partnersSlider = document.querySelector('.hk-partners-slider');
    if (partnersSlider) {
        var logoItems = partnersSlider.querySelectorAll('.hk-logo-item');
        var prevBtn = document.querySelector('.hk-partners-prev');
        var nextBtn = document.querySelector('.hk-partners-next');
        var dotsContainer = document.querySelector('.hk-partners-dots');

        var currentSlide = 0;
        var itemsPerSlide = window.innerWidth <= 768 ? 2 : 3;
        var totalSlides = Math.ceil(logoItems.length / itemsPerSlide);

        // Create dots
        function createDots() {
            if (window.innerWidth <= 768) return; // No dots on mobile
            dotsContainer.innerHTML = '';
            for (var i = 0; i < totalSlides; i++) {
                var dot = document.createElement('span');
                dot.className = 'hk-partner-dot';
                if (i === 0) dot.classList.add('active');
                dot.setAttribute('data-slide', i);
                dot.addEventListener('click', function() {
                    goToSlide(parseInt(this.getAttribute('data-slide')));
                });
                dotsContainer.appendChild(dot);
            }
        }

        function updateSlider() {
            var offset = currentSlide * 100;
            partnersSlider.style.transform = 'translateX(-' + offset + '%)';

            // Update dots
            var dots = dotsContainer.querySelectorAll('.hk-partner-dot');
            dots.forEach(function(dot, index) {
                dot.classList.toggle('active', index === currentSlide);
            });
        }

        function goToSlide(index) {
            currentSlide = index;
            if (currentSlide < 0) currentSlide = totalSlides - 1;
            if (currentSlide >= totalSlides) currentSlide = 0;
            updateSlider();
        }

        function nextSlide() {
            goToSlide(currentSlide + 1);
        }

        function prevSlide() {
            goToSlide(currentSlide - 1);
        }

        // Event listeners
        if (prevBtn) prevBtn.addEventListener('click', prevSlide);
        if (nextBtn) nextBtn.addEventListener('click', nextSlide);

        // Auto-slide
        var autoSlideInterval = setInterval(nextSlide, 5000);

        // Pause on hover (desktop only)
        if (window.innerWidth > 768) {
            partnersSlider.addEventListener('mouseenter', function() {
                clearInterval(autoSlideInterval);
            });

            partnersSlider.addEventListener('mouseleave', function() {
                autoSlideInterval = setInterval(nextSlide, 5000);
            });
        }

        // Initialize
        createDots();
        updateSlider();

        // Re-calculate on resize
        window.addEventListener('resize', function() {
            var newItemsPerSlide = window.innerWidth <= 768 ? 2 : 3;
            if (newItemsPerSlide !== itemsPerSlide) {
                itemsPerSlide = newItemsPerSlide;
                totalSlides = Math.ceil(logoItems.length / itemsPerSlide);
                currentSlide = 0;
                createDots();
                updateSlider();
            }
        });
    }
});
</script>
