<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
    // 1. Fetch Custom Theme Options
    $color_primary = get_option('hk_color_primary', '#05293c');
    $color_icon = get_option('hk_color_icon', '#80a5b4');
    $color_font = get_option('hk_color_font', '#05293c');
    $color_section_bg = get_option('hk_color_section_bg', '#f8f6f0');
    $color_button = get_option('hk_color_button', '#eaee25');

    $nama = get_option('hk_nama_ketua', '');
    $logo_utama = get_option('hk_logo_utama', '');
    $proposal_url = esc_url(get_option('hk_proposal_url', home_url('/proposal')));
    $lihat_url = esc_url(get_option('hk_lihat_url', home_url('/lihat')));
    ?>

    <style>
    :root {
        --hk-primary: <?php echo $color_primary; ?>;
        --hk-icon: <?php echo $color_icon; ?>;
        --hk-font: <?php echo $color_font; ?>;
        --hk-section-bg: <?php echo $color_section_bg; ?>;
        --hk-button: <?php echo $color_button; ?>;
    }
    body {
        margin: 0;
        padding: 0;
        background: var(--hk-section-bg);
        color: var(--hk-font);
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
    }

    /* Header Layout using Flexbox */
    .hk-header {
        width: 100%;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        z-index: 20;
    }
    .hk-header-inner {
        display: flex;
        justify-content: space-between;
        align-items: center;
        /* Padding for Mobile: 0.2rem vertically, 1rem horizontally */
        padding: 0.2rem 1rem; 
        max-width: 1200px;
        margin: 0 auto;
        transition: padding 0.3s;
    }

    /* Desktop/Larger Screen Adjustments */
    @media (min-width: 768px) {
        .hk-header-inner {
            padding: 10px 20px; /* Standard padding for desktop */
        }
    }

    /* Logo and Dropdown Styling */
    .hk-logo-dropdown {
        position: relative;
        cursor: pointer;
    }
    .hk-logo-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
        display: block;
        transition: opacity 0.3s;
    }

    /* Dropdown Menu Styling */
    .hk-dropdown-menu {
        position: absolute;
        top: calc(100% + 10px);
        right: 0;
        background-color: white;
        border-radius: 5px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        z-index: 100;
        min-width: 150px;
        display: none; /* Hidden by default */
        flex-direction: column;
        overflow: hidden;
    }
    .hk-dropdown-menu.active {
        display: flex; /* Shown when the 'active' class is added by JS */
    }
    .hk-dropdown-menu a {
        padding: 12px 20px;
        text-decoration: none;
        color: var(--hk-font);
        white-space: nowrap;
        transition: background-color 0.2s;
    }
    .hk-dropdown-menu a:hover {
        background-color: var(--hk-section-bg);
    }
    
    /* Preloader Styling */
    #preloader {
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: var(--hk-section-bg); z-index: 9999;
        display: flex; justify-content: center; align-items: center;
        opacity: 1; transition: opacity 0.5s ease-out;
    }
    .preloader-spinner {
        border: 4px solid rgba(0, 0, 0, 0.1); border-top: 4px solid var(--hk-primary);
        border-radius: 50%; width: 40px; height: 40px; animation: spin 1s linear infinite;
    }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    .loaded #preloader { opacity: 0; visibility: hidden; }
    </style>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="preloader">
    <div class="preloader-spinner"></div>
</div>
<div class="site-container">
    <header class="hk-header" style="background-color: var(--hk-primary); color: #ffffff;">
        <div class="hk-header-inner">
            <span class="hk-name">
                <?php echo esc_html($nama ? $nama : bloginfo('name')); ?>
            </span>

            <div class="hk-logo-dropdown">
                <?php if ($logo_utama): ?>
                    <img src="<?php echo esc_url($logo_utama); ?>" alt="Logo" class="hk-logo-circle" id="hk-logo-toggle">
                    
                    <div class="hk-dropdown-menu" id="hk-dropdown">
                        <a href="<?php echo $proposal_url; ?>">Bergabung</a>
                        <a href="<?php echo $lihat_url; ?>">Lihat</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </header>
    <main class="site-content">