<?php
/**
 * Template Name: Fullscreen (No Header/Footer)
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
    $color_primary = get_option('hk_color_primary', '#000000');
    $color_font = get_option('hk_color_font', '#ffffff');
    $color_section_bg = get_option('hk_color_section_bg', '#f5f5f5');
    $color_button = get_option('hk_color_button', '#007bff');
    ?>
    <style>
    :root {
        --hk-primary: <?php echo $color_primary; ?>;
        --hk-font: <?php echo $color_font; ?>;
        --hk-section-bg: <?php echo $color_section_bg; ?>;
        --hk-button: <?php echo $color_button; ?>;
    }
    body {
        margin: 0;
        padding: 0;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    }
    .fullscreen-content {
        min-height: 100vh;
        width: 100%;
    }
    </style>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="preloader">
    <div class="preloader-spinner"></div>
</div>

<div class="fullscreen-content">
    <?php
    while (have_posts()) : the_post();
        the_content();
    endwhile;
    ?>
</div>

<?php wp_footer(); ?>
<script>
window.addEventListener('load', function() {
    var preloader = document.getElementById('preloader');
    if (preloader) {
        preloader.classList.add('fade-out');
        setTimeout(function() {
            preloader.style.display = 'none';
        }, 500);
    }
});
</script>
</body>
</html>
